/*
	File:		AppearanceSample.r

	Contains:	Resources for our sample app using new Appearance types.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	12/18/97	edv		Remove UNIVERSAL_HEADERS_THREE conditional.
		 <1>	 9/11/97	edv		First checked in.
*/

#include "Menus.r"
#include "Dialogs.r"
#include "Controls.r"

#define teFlushRight -1 					/*flush right for all scripts */

resource 'xmnu' (128, purgeable)
{
	versionZero
	{
		{
			dataItem { 'abou', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph }
		}
	};
};

resource 'xmnu' (129, purgeable)
{
	versionZero
	{
		{
			dataItem { 'clos', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			skipItem {},
			dataItem { 'quit', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph }
		}
	};
};

resource 'xmnu' (130, purgeable)
{
	versionZero
	{
		{
			dataItem { 'opfw', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'opdw', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'opbd', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'newf', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'stal', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'bvli', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'cdef', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'live', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'mega', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'util', kMenuShiftModifier, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'side', kMenuShiftModifier, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'asiz', kMenuShiftModifier, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'vert', kMenuShiftModifier, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'horz', kMenuShiftModifier, currScript, 0, 0, noHierID, sysFont, naturalGlyph }
		}
	};
};

resource 'xmnu' (148, purgeable)
{
	versionZero
	{
		{
			dataItem { 'mdra', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph },
			dataItem { 'dhie', kMenuNoModifiers, currScript, 0, 0, noHierID, sysFont, naturalGlyph }
		}
	};
};

//
//	About Box resources (extended info)
//

resource 'dlgx' (5000, purgeable)
{
	versionZero
	{
		kDialogFlagsUseThemeBackground + kDialogFlagsUseThemeControls + kDialogFlagsUseControlHierarchy
	}
};

resource 'dftb' (5000, purgeable)
{
	versionZero
	{
		{
			skipItem {},
			dataItem { kDialogFontUseFontMask, kControlFontSmallSystemFont, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "" },
			dataItem { kDialogFontUseJustMask, 0, 0, 0, 0, teFlushRight, 0, 0, 0, 0, 0, 0, "" }
		}
	};
};

resource 'dftb' (6003, purgeable)
{
	versionZero
	{
		{
			skipItem {},
			skipItem {},
			skipItem {},
			skipItem {},
			dataItem { kDialogFontUseFontMask, kControlFontBigSystemFont, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "" }
		}
	};
};

//
//	Live feedback dialog stuff
//

resource 'dlgx' (1004, purgeable)
{
	versionZero
	{
		kDialogFlagsUseThemeBackground + kDialogFlagsUseControlHierarchy
	}
};

resource 'dftb' (1004, purgeable)
{
	versionZero
	{
		{
			skipItem {},
			skipItem {},
			dataItem { kDialogFontUseFontMask, kControlFontSmallSystemFont, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "" }
		}
	};
};
